from django.urls import path
from . import views
from rest_framework_simplejwt.views import (
    TokenObtainPairView,
    TokenRefreshView,
)


urlpatterns = [

     ## AUTH 
    # JWT login (get access and refresh tokens)
    path('token/', TokenObtainPairView.as_view(), name='token_obtain_pair'),
    # Refresh token
    path('token/refresh/', TokenRefreshView.as_view(), name='token_refresh'),
    # app registration
    path("app-registeruser/", views.AppUserRegistration.as_view(), name="app-registeruser"),
    path("signup-otp/", views.AppSignUpOtp.as_view(), name="signup-otp"),
    path("app-login/", views.AppUserLogin.as_view(), name="app-login"),
    path("edit-userprofile/", views.AppEditProfile.as_view(), name="edit-userprofile"),
    path("app-resetpassword/", views.AppResetPassword.as_view(), name="app-resetpassword"),
    path("update-profileimage/", views.AppUpdateProfileimage.as_view(), name="update-profileimage"),

]