
from django.shortcuts import redirect
import requests
from requests.auth import HTTPBasicAuth
from decouple import config, Csv
from django.core.mail import send_mail

#sms
sms_url = "https://apisms.beem.africa/v1/send"
beem_api_key = config("beem_api_key")
beem_secret_key = config("beem_secret_key")


# global sms function
def sendSms(phonenumber, message):
    data = {
        "source_addr": "SDA Connect",
        "encoding": 0,
        "message": message,
        "recipients": [
            {
                "recipient_id": 1,
                "dest_addr": F"{phonenumber}"
            }
        ]
    }
    username = f"{beem_api_key}"
    password = f"{beem_secret_key}"
    response = requests.post(sms_url, json=data, auth=HTTPBasicAuth(username, password))

    if response.status_code == 200:
        pass
    else:
        print("SMS sending failed. Status code:", response.status_code)
        print("Response:", response.text)

# global email function
# def sendEmail(email, from_email, subject, message):
#     try:
#         subject = subject
#         message = message
#         from_email = from_email
#         recipient_list = [email]

#         send_mail(subject, message, from_email, recipient_list, fail_silently=False)
#     except Exception as e:
#         print(f"An error occured while sending email: {e}")


def sendOTP(otp, phonenumber, email=None):
    message = f'Your One-Time Password (OTP) is: \n\n{otp} \n\nDo not share this code with anyone. \nIt will expire in 2 minutes.'
    sendSms(phonenumber, message)


